/******************** (C) COPYRIGHT 2007 STMicroelectronics ********************
* File Name            : EEPROM.h
* Author               : MCD Application Team
* Date First Issued    : 05/30/2007 : Version 1.0
* Description          : This file contains all the functions prototypes and 
*                        defined variables for the Emulated EEPROM driver.
*                      
********************************************************************************
* History:
* 05/30/2007 : Version 1.0
********************************************************************************
* THE PRESENT SOFTWARE WHICH IS FOR GUIDANCE ONLY AIMS AT PROVIDING CUSTOMERS WITH
* CODING INFORMATION REGARDING THEIR PRODUCTS IN ORDER FOR THEM TO SAVE TIME. AS
* A RESULT, STMICROELECTRONICS SHALL NOT BE HELD LIABLE FOR ANY DIRECT, INDIRECT
* OR CONSEQUENTIAL DAMAGES WITH RESPECT TO ANY CLAIMS ARISING FROM THE CONTENT
* OF SUCH SOFTWARE AND/OR THE USE MADE BY CUSTOMERS OF THE CODING INFORMATION
* CONTAINED HEREIN IN CONNECTION WITH THEIR PRODUCTS.
*******************************************************************************/
/* Define to prevent recursive inclusion ------------------------------------ */
#ifndef _EEPROM_H
#define _EEPROM_H


/* Includes ------------------------------------------------------------------*/
/* Exported types ------------------------------------------------------------*/
/* Exported constants --------------------------------------------------------*/

  
#define SECTOR_SIZE                      (u32) (0x2000)

/* Sectors 0 and 1 base and end addresses */
#define SECTOR0_BASE_ADDRESS              0x00000000 + FMI_BANK_1
#define SECTOR0_END_ADDRESS               0x00001FFF + FMI_BANK_1
#define SECTOR1_BASE_ADDRESS              0x00002000 + FMI_BANK_1
#define SECTOR1_END_ADDRESS               0x00003FFF + FMI_BANK_1


/* Sector status definitions */
#define ERASED            0xFFFF      /* The sector is empty */
#define RECEIVE_DATA      0xEEEE     /* The sector is marked to receive data */
#define VALID_SECTOR      0xCCCC    /* sector containing valid data */
#define TRANSFER_COMPLETE 0x8888  /* data transfer from a full setcor to an*/ 
                                 /*another erased is accomplished */

#define SECTOR0 (u8)(0x00)
#define SECTOR1 (u8)(0x01)
#define No_Valid_Sector (u8)(0xAB)

/* Some other needed definitions */

#define VARIABLE_FULL              0x80
#define READ_FROM_VALID_SECTOR     0x00
#define WRITE_IN_VALID_SECTOR      0x01
#define VARIABLE_EMPTY             0xBBBB




#define max_varia (u8)(0x3)       /* variables' number */


/* Module private variables --------------------------------------------------*/
/* Exported macro ------------------------------------------------------------*/
/* Private functions ---------------------------------------------------------*/
/* Exported functions ------------------------------------------------------- */

u8 EepromFormat(void);
u16 ReadVariable(u8 index, u32 *T);
u8 WriteVariable(u8 index, u32 *T, u16 data);
#endif


/******************* (C) COPYRIGHT 2007 STMicroelectronics *****END OF FILE****/

